import pyvisa
import time

from LAN_Controller import *
import re

# At the moment the FieldFox can only be used as a driven Spectrum Analyzer
class FieldFox():
    def __init__(self, hostname):
        self.hostname = hostname
        rm = pyvisa.ResourceManager()
        self.instr = rm.open_resource(self.hostname)
        self.instr.timeout = 5000
        print "-----------INITIALIZING INSTURMENT-----------\n"
        # reset
        self.command('*RST')
        # select SA Mode
        self.command('INST:SEL "SA"')
        # wait for complete
        self.query('*OPC?',verbose=False)
        # place FF into single sweep mode
        self.command('INIT:CONT 0')
        # wait for complete
        self.query('*OPC?',verbose=False)
        # set units
        self.command('SENS:AMPL:UNIT DBM')
        print "-----------INITIALIZATION COMPLETE-----------\n"

    def command(self, CMD):
        self.instr.write(CMD +'\n')

    def query(self, CMD, show_response = True, verbose=False):
        out = self.instr.query(CMD)
        return out

    # power level must be between -45 and 0
    def configureSource(self,freq,pwr=-15):
        print "-----------PREPARING SOURCE-----------\n"
        # Enable Source
        self.command('SOUR:ENAB 1')
        # set to continuous mode
        self.command('SOUR:MODE CW')
        # set frequency
        self.command('SOUR:FREQ ' + str(freq))
        # set power
        self.command('SOUR:POW ' + str(pwr))

    # only measure center freq
    # sweeptime must be greater than 1us
    # rbw (Res bandwidth) should be between 10Hz and 2 MHz
    # vbw (video bandwidth) should be between 1Hz and 2 MHz
    def prepSingleFreqMeasurement(self, freq, sweepTime, rbw, vbw):#, ifbw):
        print "-----------PREPARING SWEEP-----------\n"
        # set center frequency
        self.command('FREQ:CENT ' + str(freq))
        # set span to zero
        self.command('FREQ:SPAN:ZERO')

        # set sweep time
        self.command('SWE:TIME ' + str(sweepTime))
        # get sweep time
        self.sweepTime = self.query('SENS:SWE:TIME?')
        # set RES Bandwidth
        self.command('SENS:BAND:RES:AUTO 0')
        self.command('SENS:BAND:RES ' + str(rbw))
        # set VID Bandwidth
        self.command('SENS:BAND:VID:AUTO 0')
        self.command('SENS:BAND:VID ' + str(vbw))


        # create marker
        self.command('CALC:MARK1:ACT')
        # make marker integrate over full sweep
        self.command('CALC:MARK1:FUNC:INT:SPAN:AUTO 0')
        self.command('CALC:MARK:FUNC:INT:SPAN ' + self.sweepTime)
        print self.sweepTime

    # measure spectrum
    # sweeptime must be greater than 1us
    # rbw (Res bandwidth) should be between 10Hz and 2 MHz
    # vbw (video bandwidth) should be between 1Hz and 2 MHz
    def prepSpectrumMeasurement(self, freq, span, rbw, vbw):#, ifbw):
        print "-----------PREPARING SWEEP-----------\n"
        # set center frequency
        time.sleep(0.1)
        self.command('FREQ:CENT ' + str(freq))
        # set span
        time.sleep(0.1)
        self.command('FREQ:SPAN ' + str(span))

        # set RES Bandwidth
        time.sleep(0.1)
        self.command('SENS:BAND:RES:AUTO 0')
        time.sleep(0.1)
        self.command('SENS:BAND:RES ' + str(rbw))
        # set VID Bandwidth
        time.sleep(0.1)
        self.command('SENS:BAND:VID:AUTO 0')
        time.sleep(0.1)
        self.command('SENS:BAND:VID ' + str(vbw))

        time.sleep(0.1)
        self.command('FREQ:CENT ' + str(freq))

        # get sweep time
        time.sleep(0.1)
        self.sweepTime = self.query('SENS:SWE:TIME?')

        # create marker
        time.sleep(0.1)
        self.command('CALC:MARK1:ACT')
        # place marker at center frequency
        time.sleep(0.1)
        self.command('CALC:MARK1:SET:CENT')
        print self.sweepTime

    def sweep(self, verbose=True):
        if verbose:
            print "-----------Taking SWEEP-----------\n"
        self.command('INIT:IMM')
        # wait for complete
        self.query('*OPC?',verbose=False)
        return self.query('CALC:MARK1:Y?')

    def getSpectrum(self, verbose=True):
        if verbose:
            print "-----------Taking SWEEP-----------\n"
        self.command('INIT:IMM')
        # wait for complete
        self.query('*OPC?',verbose=False)
        data_str = self.query('TRACE:DATA?')
        data_str = data_str.split(",")
        return [float(point) for point in data_str]
